<?php

namespace App\Exports;

use App\Models\Asset;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Events\AfterSheet;
use Maatwebsite\Excel\Concerns\FromCollection;
use Illuminate\Support\Carbon;

class HardwareExport implements FromCollection, WithHeadings, WithEvents
{
    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection()
    {
        $data = [];
        $assets = Asset::with(['user'])->get();
        foreach ($assets as $asset) {
            $data[] = [
                'name' => $asset->asset_name ?? '',
                'model_number' => $asset->model_number ?? '',
                'serial_number' => $asset->serial_number ?? '',
                'brand_model' => $asset->brandModel->brand_model_name ?? '',
                'branch' => $asset->branch->name ?? '',
                'condition' => $asset->assetCondition->name ?? '',
                'status' => $asset->assetStatus->name ?? '',
                'assigned_to' => $asset->allocated_entity,
                'asset_tag' => $asset->asset_tag ?? '',
                'capitalization_date' => Carbon::parse($asset->capitalization_date)->format('d-m-Y') ?? '',
                'acquisition_date' => Carbon::parse($asset->acquisition_date)->format('d-m-Y') ?? '',
                'vendor' => $asset->vendor->name ?? '',
                'bulding' => $asset->building ?? '',
                'floor' => $asset->floor ?? '',
                'room' => $asset->room ?? '',
                'descriptions' => $asset->descriptions,
                'created_by' => $asset->user->name ?? ''
            ];
        }
        return collect($data);
    }

    public function headings(): array{
        return ['Name', 'Model Number', 'Serial Number', 'Brand', 'Branch', 'Condition', 'Status','Allocated','Asset Tag/Barcode',
            'Capitalization Date','Acquisition Date','Vendor/Supplier','Building','Floor','Room','Description','Created By'];
    }

    public function registerEvents(): array
    {
        return [
            AfterSheet::class => function(AfterSheet $event) {
                $sheet = $event->sheet->getDelegate();
                $sheet->getStyle('A1:Q1')->applyFromArray([
                    'font' => ['bold' => true, 'color' => ['argb' => 'FFFFFFFF']],
                    'fill' => [
                        'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                        'startColor' => ['argb' => '273488'], // blue background
                    ],
                    'alignment' => ['horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER],
                ]);
            },
        ];
    }
}
