<?php

namespace App\Http\Controllers\API\Operations;

use App\Exports\HardwareExport;
use App\Http\Controllers\Controller;
use App\Models\Asset;
use App\Models\Traits\HttpResponses;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Gate;
use Maatwebsite\Excel\Facades\Excel;
use Symfony\Component\HttpFoundation\Response;
use Illuminate\Support\Carbon;
use Barryvdh\DomPDF\Facade\Pdf as PDF;

class ReportController extends Controller
{
    use HttpResponses;

    public function hardware_assets_excel(){
        if (!Gate::allows('View Reports')) {
            return $this->error('Permission Denied', [], Response::HTTP_FORBIDDEN);
        }
        return Excel::download(new HardwareExport(), 'hardware_report.xlsx', \Maatwebsite\Excel\Excel::XLSX);
    }

    public function hardware_assets_pdf(){
        if (!Gate::allows('View Reports')) {
            return $this->error('Permission Denied', [], Response::HTTP_FORBIDDEN);
        }

        $data = [];
        $assets = Asset::with(['user'])->get();
        foreach ($assets as $asset) {
            $data[] = [
                'name' => $asset->asset_name ?? '',
                'model_number' => $asset->model_number ?? '',
                'serial_number' => $asset->serial_number ?? '',
                'brand_model' => $asset->brandModel->brand_model_name ?? '',
                'branch' => $asset->branch->name ?? '',
                'condition' => $asset->assetCondition->name ?? '',
                'status' => $asset->assetStatus->name ?? '',
                'assigned_to' => $asset->allocated_entity,
                'asset_tag' => $asset->asset_tag ?? '',
                'capitalization_date' => Carbon::parse($asset->capitalization_date)->format('d-m-Y') ?? '',
                'acquisition_date' => Carbon::parse($asset->acquisition_date)->format('d-m-Y') ?? '',
                'vendor' => $asset->vendor->name ?? '',
                'bulding' => $asset->building ?? '',
                'floor' => $asset->floor ?? '',
                'room' => $asset->room ?? '',
                'descriptions' => $asset->descriptions,
                'created_by' => $asset->user->name ?? ''
            ];
        }
        $pdf = PDF::loadView('reports.hardware', compact('data'))->setPaper('A4', 'landscape');
        return $pdf->download('hardware_report.pdf');
    }

    public function test(){
        $data = [];
        $assets = Asset::get();
        foreach ($assets as $asset) {
            $data[] = [
                'name' => $asset->asset_name ?? '',
                'model_number' => $asset->model_number ?? '',
                'serial_number' => $asset->serial_number ?? '',
                'brand_model' => $asset->brandModel->brand_model_name ?? '',
                'branch' => $asset->branch->name ?? '',
                'condition' => $asset->assetCondition->name ?? '',
                'status' => $asset->assetStatus->name ?? '',
                'assigned_to' => $asset->allocated_entity,
                'asset_tag' => $asset->asset_tag ?? '',
                'capitalization_date' => Carbon::parse($asset->capitalization_date)->format('d-m-Y') ?? '',
                'acquisition_date' => Carbon::parse($asset->acquisition_date)->format('d-m-Y') ?? '',
                'vendor' => $asset->vendor->name ?? '',
                'bulding' => $asset->building ?? '',
                'floor' => $asset->floor ?? '',
                'room' => $asset->room ?? '',
                'descriptions' => $asset->descriptions,
                'created_by' => "User"
            ];
        }

        return collect($data);
    }
}
