<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ApplicationAsset extends Model
{
    protected $fillable = [
        'ownership_id',
        'name',
        'type', //SOFTWARE , SERVICE
        'requisition_date',
        'descriptions',
        'created_by',
        'status',
    ];


    public function ownership()
    {
        return $this->belongsTo(Vendor::class, 'ownership_id');
    }

    public function createdBy()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function applicationAssetVendors()
    {
        return $this->hasMany(ApplicationAssetVendor::class);
    }
}
