<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ApplicationAssetVendor extends Model
{
    protected $fillable = [
        'application_asset_id',
        'vendor_id',
        'branch_id',
        'date',
        'created_by',
    ];

    public function applicationAsset()
    {
        return $this->belongsTo(ApplicationAsset::class);
    }

    public function vendor()
    {
        return $this->belongsTo(Vendor::class);
    }

    public function branch()
    {
        return $this->belongsTo(Branch::class);
    }

    public function createdBy()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function applicationAssetVendorContracts()
    {
        return $this->hasMany(ApplicationAssetVendorContract::class);
    }
}
