<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ApplicationAssetVendorContract extends Model
{
    protected $fillable = [
        'application_asset_vendor_id',
        'start_date',
        'end_date',
        'document_path',
        'created_by',
        'status',
    ];

    public function applicationAssetVendor()
    {
        return $this->belongsTo(ApplicationAssetVendor::class);
    }

    public function createdBy()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function applicationAssetVendorContractRenewals()
    {
        return $this->hasMany(ApplicationAssetVendorContractRenewal::class);
    }

    public function getContractStatusAttribute()
    {
        return now()->between($this->start_date, $this->end_date) ? 'Active' : 'Expired';
    }

    public function getHasActiveContractAttribute()
    {
        return now()->between($this->start_date, $this->end_date) ? 1 : 0;
    }
}
