<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ApplicationAssetVendorContractRenewal extends Model
{
    protected $fillable = [
        'application_asset_vendor_contract_id',
        'start_date',
        'end_date',
        'cost',
        'descriptions',
        'created_by',
    ];

    public function contract()
    {
        return $this->belongsTo(ApplicationAssetVendorContract::class, 'application_asset_vendor_contract_id');
    }

    public function createdBy()
    {
        return $this->belongsTo(User::class, 'created_by');
    }
}
