<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

class AssetAllocation extends Model
{
    protected $fillable = [
        'asset_id',
        'employee_id',
        'branch_id',
        'status',
        'allocated_by',
        'unallocated_by',
        'assigned_date',
        'unassigned_date',
        'reasons',
        'descriptions',
    ];

    public function asset()
    {
        return $this->belongsTo(Asset::class);
    }

    public function employee()
    {
        return $this->belongsTo(Employee::class);
    }

    public function branch()
    {
        return $this->belongsTo(Branch::class);
    }

    public function allocatedBy()
    {
        return $this->belongsTo(User::class, 'allocated_by');
    }

    public function unallocatedBy()
    {
        return $this->belongsTo(User::class, 'unallocated_by');
    }

    public function getDateAssignedAttribute()
    {
        return $this->assigned_date ? Carbon::parse($this->assigned_date)->format('M d, Y') : 'Not Available';
    }

    public function getDateUnassignedAttribute()
    {
        return $this->unassigned_date ? Carbon::parse($this->unassigned_date)->format('M d, Y') : 'Not Available';
    }

    public function getAllocationStatusAttribute()
    {
        return $this->status ? 'Active' : 'Inactive';
    }
    
}
