<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class AssetBranchPoint extends Model
{
    protected $fillable = [
        'id',
        'asset_id',
        'branch_point_id',
        'created_by',
        'status',
    ];

    public function asset()
    {
        return $this->belongsTo(Asset::class);
    }

    public function branchPoint()
    {
        return $this->belongsTo(branchPoint::class);
    }

    public function createdBy()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function getAssetBranchPointStatusAttribute()
    {
        return $this->status ? 'Active' : 'Inactive';
    }
}
