<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

class AssetMaintenance extends Model
{
    protected $fillable = [
        'asset_id',
        'date',
        'next_date',
        'remarks',
        'descriptions',
        'fault_description',
        'created_by',
        'status', //COMPLETE, FAILED
    ];

    public function asset()
    {
        return $this->belongsTo(Asset::class);
    }

    public function createdBy()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function getMaintenanceStatusAttribute()
    {
        if ($this->status === 'COMPLETED') {
            return 'Completed';
        } elseif ($this->status === 'FAILED') {
            return 'Failed';
        }
    }

    public function getPlanDateAttribute()
    {
        return $this->next_date ? Carbon::parse($this->unassigned_date)->format('M d, Y') : 'Not Available';

    }
}
