<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class AssetStateHistory extends Model
{
    protected $fillable = [
        'asset_id',
        'status_id',
        'condition_id',
        'descriptions',
        'created_by'
    ];

    public function asset()
    {
        return $this->belongsTo(Asset::class);
    }

    public function assetCondition()
    {
        return $this->belongsTo(AssetCondition::class, 'condition_id');
    }

    public function assetStatus()
    {
        return $this->belongsTo(AssetStatus::class, 'status_id');
    }

    public function createdBy()
    {
        return $this->belongsTo(User::class, 'created_by');
    }
}
