<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Branch extends Model
{
    protected $fillable = [
        'name',
        'id'
    ];

    public function branchPoints()
    {
        return $this->hasMany(BranchPoint::class);
    }

    public function getNameAttribute()
    {
        return isset($this->attributes['name'])
            ? ucwords(strtolower($this->attributes['name']))
            : "";
    }

    public function getHasBranchPointAttribute()
    {
        return $this->branchPoints()->exists();
    }
}
