<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class BranchPoint extends Model
{
    protected $fillable = [
        'id',
        'branch_id',
        'name',
        'created_by',
        'status'
    ];

    public function branch()
    {
        return $this->belongsTo(Branch::class);
    }

    public function createdBy()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function getBranchPointStatusAttribute()
    {
        return $this->status ? 'Active' : 'Inactive';
    }

    public function getNameAttribute()
    {
        return isset($this->attributes['name'])
            ? ucwords(strtolower($this->attributes['name']))
            : "";
    }
}
