<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Brand extends Model
{
    protected $fillable = [
        'name',
        'descriptions'
    ];

    public function brandModels()
    {
        return $this->hasMany(BrandModel::class);
    }

    public function getNameAttribute()
    {
        return isset($this->attributes['name'])
            ? ucwords(strtolower($this->attributes['name']))
            : "";
    }
}
