<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class BrandModel extends Model
{
    protected $fillable = [
        'id',
        'brand_id',
        'name',
        'status',
    ];

    public function brand()
    {
        return $this->belongsTo(Brand::class);
    }

    public function getBrandModelStatusAttribute()
    {
        return $this->status ? 'Active' : 'Inactive';
    }

    public function getBrandModelNameAttribute()
    {
        $name = $this->name;

        if (!empty($this->brand->name)) {
            $name .= ' (' . $this->brand->name . ')';
        }
        return $name;
    }

    public function getBrandModelBrandIdAttribute()
    {
        return $this->brand_id ?? '';
    }

    public function getNameAttribute()
    {
        return isset($this->attributes['name'])
            ? ucwords(strtolower($this->attributes['name']))
            : "";
    }
}
