<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Category extends Model
{
    protected $fillable = [
        'name',
        'category_group_id',
        'expected_useful_life'
    ];

    public function categoryGroup()
    {
        return $this->belongsTo(CategoryGroup::class);
    }

    public function getGroupNameAttribute()
    {
        $name = $this->name;

        if (!empty($this->categoryGroup->name)) {
            $name .= ' (' . $this->categoryGroup->name . ')';
        }
        return trim($name);
    }

    public function getIsAssignableAttribute()
    {
        return $this->categoryGroup?->is_assignable ? true : false;
    }

    public function getNameAttribute()
    {
        return isset($this->attributes['name'])
            ? ucwords(strtolower($this->attributes['name']))
            : "";
    }
}
