<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class CategoryGroup extends Model
{
    protected $fillable = [
        'id',
        'name',
        'descriptions',
        'is_assignable',
    ];

    public function getIsAssignableStatusAttribute()
    {
        return $this->is_assignable ? true : false;
    }

    public function getIsAssignableBadgeAttribute()
    {
        return $this->is_assignable ? true : false;
    }

    public function getNameAttribute()
    {
        return isset($this->attributes['name'])
            ? ucwords(strtolower($this->attributes['name']))
            : "";
    }
}
