<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Employee extends Model
{
    protected $fillable = [
        'name',
        'email',
        'id',
        'phone',
        'designation',
        'status',
        'department',
        'branch',
        'profile_picture'
    ];

    public function assetAllocations()
    {
        return $this->hasMany(AssetAllocation::class);
    }

    public function getEmployeeStatusAttribute()
    {
        return $this->status ? 'Active' : 'Inactive';
    }

    public function getNameAttribute()
{
    return isset($this->attributes['name'])
        ? ucwords(strtolower($this->attributes['name']))
        : "";
}

}
