<?php

use Illuminate\Auth\AuthenticationException;
use Illuminate\Foundation\Application;
use Illuminate\Foundation\Configuration\Exceptions;
use Illuminate\Foundation\Configuration\Middleware;
use Illuminate\Http\Request;

return Application::configure(basePath: dirname(__DIR__))
    ->withRouting(
        web: __DIR__.'/../routes/web.php',
        api: __DIR__.'/../routes/api.php',
        commands: __DIR__.'/../routes/console.php',
        health: '/up',
    )
    ->withMiddleware(function (Middleware $middleware) {
        $middleware->alias([
            'role' => \Spatie\Permission\Middleware\RoleMiddleware::class,
            'permission' => \Spatie\Permission\Middleware\PermissionMiddleware::class,
            'role_or_permission' => \Spatie\Permission\Middleware\RoleOrPermissionMiddleware::class
        ]);
    })
    ->withExceptions(function (Exceptions $exceptions) {
        $exceptions->render(function (AuthenticationException $e, Request $request) {
            if ($request->is('api/*')) {
                return response()->json([
                    'message' => $e->getMessage(),
                ], 401);
            }
        });

        $exceptions->render(function (\Spatie\Permission\Exceptions\PermissionDoesNotExist $e, $request) {
            return response()->json([
                'message' => 'You are not authorized to access this resource '.url()->current(),
                'response'  => $e->getMessage(),
                'code' => 403
            ], 403);
        });

        $exceptions->render(function (Throwable $e, $request) {
            // return response()->json([
            //     'file' => $e->getFile(),
            //     'line' => $e->getLine(),
            //     'message' => $e->getMessage(),
            //     'trace' => $e->getTrace(),
            // ], 500);
        });

    })->create();
