<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('assets', function (Blueprint $table) {
            $table->id();
            $table->string('name')->nullable();
            $table->unsignedBigInteger('category_id'); //asset name
            $table->unsignedBigInteger('vendor_id')->nullable();
            $table->unsignedBigInteger('branch_id')->nullable();
            $table->unsignedBigInteger('status_id')->nullable();
            $table->unsignedBigInteger('condition_id')->nullable();
            $table->unsignedBigInteger('brand_model_id')->nullable();
            $table->unsignedBigInteger('department_id')->nullable(); // sections (ict, pmu, insurance, hr, audit)

            $table->string('serial_number')->unique();
            $table->string('model_number');
            $table->string('asset_tag')->nullable(); //internal reference / zic or barcode
            $table->date('capitalization_date'); //on service date
            $table->date('acquisition_date')->nullable(); //registered date
            $table->text('descriptions')->nullable();
            $table->unsignedBigInteger('created_by')->nullable();
            
            //other parameters
            $table->string('building')->nullable();
            $table->string('room')->nullable();
            $table->string('floor')->nullable();
            $table->string('old_status')->nullable();
            $table->softDeletes();
            $table->timestamps();

            $table->foreign('category_id')->references('id')->on('categories')->onDelete('restrict')->onUpdate('cascade');
            $table->foreign('vendor_id')->references('id')->on('vendors')->onDelete('restrict')->onUpdate('cascade');
            $table->foreign('branch_id')->references('id')->on('branches')->onDelete('restrict')->onUpdate('cascade');
            $table->foreign('status_id')->references('id')->on('asset_statuses')->onDelete('restrict')->onUpdate('cascade');
            $table->foreign('condition_id')->references('id')->on('asset_conditions')->onDelete('restrict')->onUpdate('cascade');
            $table->foreign('brand_model_id')->references('id')->on('brand_models')->onDelete('restrict')->onUpdate('cascade');
            $table->foreign('created_by')->references('id')->on('users')->onDelete('restrict')->onUpdate('cascade');
            $table->foreign('department_id')->references('id')->on('departments')->onDelete('restrict')->onUpdate('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('assets');
    }
};
