<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('asset_allocations', function (Blueprint $table) {
            $table->id();
            $table->foreignId('asset_id')->constrained('assets')->onDelete('restrict');
            $table->foreignId('employee_id')->nullable()->constrained('employees')->onDelete('restrict');
            $table->foreignId('branch_id')->constrained('branches')->onDelete('restrict');
            $table->foreignId('allocated_by')->constrained('users')->onDelete('restrict');
            $table->foreignId('unallocated_by')->nullable()->constrained('users')->onDelete('restrict');
            $table->date('assigned_date')->nullable();
            $table->date('unassigned_date')->nullable();
            $table->text('reasons')->nullable();
            $table->text('descriptions')->nullable();
            $table->boolean('status');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('asset_allocations');
    }
};
