<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('asset_maintenances', function (Blueprint $table) {
            $table->id();
            $table->foreignId('asset_id')->constrained('assets')->onDelete('restrict'); 
            $table->date('date');
            $table->date('next_date')->nullable();
            $table->text('remarks')->nullable();
            $table->text('descriptions');
            $table->text('fault_description');
            $table->foreignId('created_by')->constrained('users')->onDelete('restrict');
            $table->enum('status', ['COMPLETED', 'FAILED']);
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('asset_maintenances');
    }
};
