<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('application_assets', function (Blueprint $table) {
            $table->id();
            $table->foreignId('ownership_id')->nullable()->constrained('vendors')->onDelete('restrict');
            $table->string('name');
            $table->enum('type', ['SOFTWARE', 'SERVICE']);
            $table->date('requisition_date');
            $table->string('descriptions')->nullable();
            $table->foreignId('created_by')->constrained('users')->onDelete('restrict');
            $table->boolean('status');
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('application_assets');
    }
};
