<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('application_asset_vendor_contracts', function (Blueprint $table) {
            $table->id();
            $table->foreignId('application_asset_vendor_id')
                ->constrained('application_asset_vendors', 'id', 'fk_aavc_vendor')
                ->onDelete('restrict');
            $table->date('start_date');
            $table->date('end_date');
            $table->string('document_path')->nullable();
            $table->foreignId('created_by')->constrained('users')->onDelete('restrict');
            $table->boolean('status')->default('1');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('application_asset_vendor_contracts');
    }
};
