<?php

namespace Database\Seeders;

use App\Models\ApplicationAsset;
use App\Models\Asset;
use App\Models\AssetAllocation;
use App\Models\AssetCondition;
use App\Models\AssetStatus;
use App\Models\Branch;
use App\Models\BranchPoint;
use App\Models\Brand;
use App\Models\Category;
use App\Models\CategoryGroup;
use App\Models\Department;
use App\Models\Employee;
use App\Models\Vendor;
use Carbon\Carbon;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;

class LoadingDataSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {

        $condition = ['New', 'Good', 'Fair', 'Poor', 'Scrap'];
        foreach ($condition as $item) {
            AssetCondition::create(['name' => $item]);
        }

        $status = ['In Use', 'In Storage', 'Under Repair', 'Retired', 'Disposed'];
        foreach ($status as $item) {
            AssetStatus::create(['name' => $item]);
        }

        $brand = ['Hp', 'Dell', 'Huawei', 'Lenovo', 'Samsung', 'D-link', 'Cisco', 'Sophos', 'Microsoft'];
        foreach ($brand as $item) {
            Brand::create(['name' => $item]);
        }

        $response = Http::timeout(120)->get('https://ict.shirikalabima.co.tz/api/transfer');
        if ($response->successful()) {
            $data = $response->json();
            //vendors
            foreach ($data['vendors'] as $item) {
                Vendor::create([
                    'name' => $item['name'],
                    'email' => null,
                    'id' => $item['id'],
                    'phone' => $item['phone'],
                    'contact_person' => $item['contact_person'],
                    'address' => $item['address']
                ]);
            }
            //branches
            foreach ($data['branch'] as $item) {
                Branch::create([
                    'name' => $item['name'],
                    'id' => $item['id'],
                ]);
            }
            //employee
            foreach ($data['employee'] as $item) {
                Employee::create([
                    'name' => $item['name'],
                    'id' => $item['id'],
                    'email' => $item['email'],
                    'phone' => $item['phone'],
                    'status' => 1
                ]);
            }
            //category
            foreach ($data['category'] as $item) {
                Category::create([
                    'name' => $item['name'],
                    'id' => $item['id'],
                    'category_group_id' => null
                ]);
            }
            //department
            foreach ($data['department'] as $item) {
                Department::create([
                    'name' => $item['name'],
                    'id' => $item['id'],
                ]);
            }

            foreach ($data['department'] as $item) {
                BranchPoint::create([
                    'branch_id' =>  1,
                    'name' => $item['name'],
                    'created_by' => 1,
                    'status' => 1
                ]);
            }
            //group
            foreach ($data['group'] as $item) {
                CategoryGroup::create([
                    'name' => $item['name'],
                    'id' => $item['id'],
                ]);
            }
            //assets
            foreach ($data['assets'] as $item) {
                Asset::create([
                    'id' => $item['id'],
                    'name' => $item['name'],
                    'category_id' => $item['categoryId'],
                    'branch_id' => $item['branch_id'],
                    'condition_id' => null,
                    'status_id' => null,
                    'vendor_id' => $item['provider_id'],
                    'brand_model_id' => null,
                    'department_id' => null,
                    'serial_number' => $item['serialNumber'],
                    'model_number' => $item['modelNumber'],
                    'asset_tag' => $item['barcode'],
                    'capitalization_date' => $item['serviceDate'],
                    'acquisition_date' => $item['registeredDate'],
                    'descriptions' => $item['detail'],
                    'created_by' => null,
                    //other parameters
                    'building' => null,
                    'room' => null,
                    'floor' => null,
                    'old_status' => $item['status']
                ]);
            }
            //assets allocations
            foreach ($data['employee_asset'] as $item) {
                AssetAllocation::create([
                    'asset_id' => $item['assetId'],
                    'employee_id' => $item['employeeId'],
                    'branch_id' => $item['locationId'],
                    'assigned_date' => $item['assignedDate'],
                    'unassigned_date' => $item['unassignedDate'],
                    'reasons' => $item['unallocatedReason'],
                    'descriptions' => null,
                    'allocated_by' => 1,
                    'status' => $item['status'],
                ]);
            }

            //services - software
            foreach ($data['services'] as $item) {
                ApplicationAsset::create([
                    'ownership_id' => $item['vendorId'],
                    'name' => $item['name'],
                    'type' => 'SOFTWARE',
                    'requisition_date' => Carbon::parse($item['created_at'])->format('Y-m-d'),
                    'descriptions' => null,
                    'created_by' => 1,
                    'status' => 1,
                ]);
            }

            Log::info('success', $data);
            return;
        }

        Log::info('Fail to fetch the data on https://ict.shirikalabima.co.tz/api/transfer');
        return;
    }
}
