<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;

class PermissionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $permissions = [
            'Create Asset',
            'Update Asset',
            'Delete Asset',
            'View Asset',
            'Manage Asset',

            'Create Category Group',
            'Update Category Group',
            'Delete Category Group',
            'View Category Group',
            'Manage Category Group',

            'Create Category',
            'Update Category',
            'Delete Category',
            'View Category',
            'Manage Category',

            'Create Brand',
            'Update Brand',
            'Delete Brand',
            'View Brand',
            'Manage Brand',

            'Create Brand Model',
            'Update Brand Model',
            'Delete Brand Model',
            'View Brand Model',
            'Manage Brand Model',

            'Create Asset Status',
            'Update Asset Status',
            'Delete Asset Status',
            'View Asset Status',
            'Manage Asset Status',

            'Create Asset Condition',
            'Update Asset Condition',
            'Delete Asset Condition',
            'View Asset Condition',
            'Manage Asset Condition',

            'Create Asset State History',
            'Update Asset State History',
            'Delete Asset State History',
            'View Asset State History',
            'Manage Asset State History',

            'Create Asset Allocation',
            'Update Asset Allocation',
            'Delete Asset Allocation',
            'View Asset Allocation',
            'Manage Asset Allocation',

            'Create Asset Maintenance',
            'Update Asset Maintenance',
            'Delete Asset Maintenance',
            'View Asset Maintenance',
            'Manage Asset Maintenance',

            'Create Vendor',
            'Update Vendor',
            'Delete Vendor',
            'View Vendor',
            'Manage Vendor',

            'View Employee',
            'Manage Employee',

            'Create Branch',
            'View Branch',
            'Manage Branch',
            'Update Branch',
            'Delete Branch',

            'Create Branch Point',
            'View Branch Point',
            'Manage Branch Point',
            'Update Branch Point',
            'Delete Branch Point',

            'View Software Asset',
            'Create Software Asset',

            'View Service Asset',
            'Create Service Asset',

            'View Software Asset Vendor',
            'Create Software Asset Vendor',

            'View Service Asset Vendor',
            'Create Service Asset Vendor',

            'View Service Asset Vendor Contract',
            'Create Service Asset Vendor Contract',

            'User Management',
            'Role Management',

            'View Reports'

        ];

        foreach ($permissions as $permission) {
            Permission::updateOrCreate(
                ['name' => $permission], // find by name
            );
        }

        $roles = [
            'Root',
            'Admin',
            'Manager',
            'User',
        ];

        foreach ($roles as $role) {
            Role::updateOrCreate([
                'name' => $role
            ]);
        }

        $root = Role::find(1);

        $permissions = Permission::pluck('name', 'name')->all();
        $root->syncPermissions($permissions);
    }
}
