<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;

class RoleSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $roles = [
            'Root', 'Admin', 'Manager','User',
        ];

        foreach($roles as $role){
            Role::create([
                'name' => $role
            ]);
        }

        $root = Role::find(1);

        $permissions = Permission::pluck('name','name')->all();
        $root->syncPermissions($permissions);
        // $admin->syncPermissions(['Add Asset', 'Edit Asset', 'Delete Asset']);
        // $manager->syncPermissions(['Add Branch', 'Edit Branch', 'Delete Branch']);
    }
}
