<?php

use App\Http\Controllers\API\Administrations\BranchApiController;
use App\Http\Controllers\API\Administrations\EmployeeApiController;
use App\Http\Controllers\API\ApplicationAssets\ApplicationAssetApiController;
use App\Http\Controllers\API\ApplicationAssets\ApplicationAssetVendorApiController;
use App\Http\Controllers\API\ApplicationAssets\ApplicationAssetVendorContractApiController;
use App\Http\Controllers\API\Assets\AssetAllocationApiController;
use App\Http\Controllers\API\Assets\AssetApiController;
use App\Http\Controllers\API\Assets\AssetMaintenanceApiController;
use App\Http\Controllers\API\Assets\AssetStateHistoryApiController;
use App\Http\Controllers\API\AuthController;
use App\Http\Controllers\API\Operations\DashboardApiController;
use App\Http\Controllers\API\Operations\ReportController;
use App\Http\Controllers\API\Setups\AssetConditionApiController;
use App\Http\Controllers\API\Setups\AssetStatusApiController;
use App\Http\Controllers\API\Setups\BranchPointApiController;
use App\Http\Controllers\API\Setups\BrandApiController;
use App\Http\Controllers\API\Setups\BrandModelApiController;
use App\Http\Controllers\API\Setups\CategoryApiController;
use App\Http\Controllers\API\Setups\CategoryGroupApiController;
use App\Http\Controllers\API\Setups\VendorApiController;
use Illuminate\Support\Facades\Route;


Route::group(['middleware' => 'api', 'prefix' => 'v1'], function ($router) {

    Route::post('test', [ReportController::class, 'hardware_assets']);

    Route::prefix('/auth')->group(function () {
        Route::post('login', [AuthController::class, 'login']);
    });

    Route::middleware('auth:api')->group(function () {
        
        Route::prefix('setups')->group(function () {

            Route::prefix('category-groups')->group(function () {
                Route::get('index', [CategoryGroupApiController::class, 'index']);
                Route::get('show', [CategoryGroupApiController::class, 'show']);
                Route::post('store', [CategoryGroupApiController::class, 'store']);
                Route::post('update', [CategoryGroupApiController::class, 'update']);
                Route::get('select', [CategoryGroupApiController::class, 'categoryGroupForSelect']);
            });

            Route::prefix('categories')->group(function () {
                Route::get('index', [CategoryApiController::class, 'index']);
                Route::get('show', [CategoryApiController::class, 'show']);
                Route::post('store', [CategoryApiController::class, 'store']);
                Route::post('update', [CategoryApiController::class, 'update']);
                Route::get('select', [CategoryApiController::class, 'categoryForSelect']);
            });

            Route::prefix('brands')->group(function () {
                Route::get('index', [BrandApiController::class, 'index']);
                Route::get('show', [BrandApiController::class, 'show']);
                Route::post('store', [BrandApiController::class, 'store']);
                Route::post('update', [BrandApiController::class, 'update']);
                Route::get('select', [BrandApiController::class, 'brandForSelect']);
            });

            Route::prefix('brand-models')->group(function () {
                Route::get('index', [BrandModelApiController::class, 'index']);
                Route::get('show', [BrandModelApiController::class, 'show']);
                Route::post('store', [BrandModelApiController::class, 'store']);
                Route::post('update', [BrandModelApiController::class, 'update']);
                Route::get('select', [BrandModelApiController::class, 'brandModelForSelect']);
                Route::get('select/{brand_id}', [BrandModelApiController::class, 'brandModelByBrandId']);
            });

            Route::prefix('asset-status')->group(function () {
                Route::get('index', [AssetStatusApiController::class, 'index']);
                Route::get('show', [AssetStatusApiController::class, 'show']);
                Route::post('store', [AssetStatusApiController::class, 'store']);
                Route::post('update', [AssetStatusApiController::class, 'update']);
                Route::get('select', [AssetStatusApiController::class, 'statusForSelect']);
            });

            Route::prefix('asset-conditions')->group(function () {
                Route::get('index', [AssetConditionApiController::class, 'index']);
                Route::get('show', [AssetConditionApiController::class, 'show']);
                Route::post('store', [AssetConditionApiController::class, 'store']);
                Route::post('update', [AssetConditionApiController::class, 'update']);
                Route::get('select', [AssetConditionApiController::class, 'conditionForSelect']);
            });

            Route::prefix('vendors')->group(function () {
                Route::get('index', [VendorApiController::class, 'index']);
                Route::get('show', [VendorApiController::class, 'show']);
                Route::post('store', [VendorApiController::class, 'store']);
                Route::post('update', [VendorApiController::class, 'update']);
                Route::get('select', [VendorApiController::class, 'vendorForSelect']);
            });
        });

        Route::prefix('assets')->group(function () {
            Route::get('index', [AssetApiController::class, 'index']);
            Route::get('show', [AssetApiController::class, 'show']);
            Route::post('store', [AssetApiController::class, 'store']);
            Route::post('update', [AssetApiController::class, 'update']);
            Route::get('asset-options', [AssetApiController::class, 'asset_options']);
            Route::get('select', [AssetApiController::class, 'assetForSelect']);
            Route::get('details', [AssetApiController::class, 'assetDetails']);

            Route::prefix('histories')->group(function () {
                Route::get('index', [AssetStateHistoryApiController::class, 'index']);
                Route::post('update', [AssetStateHistoryApiController::class, 'update']);
            });

            Route::prefix('allocations')->group(function () {
                Route::get('index', [AssetAllocationApiController::class, 'index']);
                Route::post('store', [AssetAllocationApiController::class, 'store']);
                Route::get('select-options', [AssetAllocationApiController::class, 'selectOption']);
            });

            Route::prefix('maintenances')->group(function () {
                Route::get('index', [AssetMaintenanceApiController::class, 'index']);
                Route::post('store', [AssetMaintenanceApiController::class, 'store']);
                Route::get('show', [AssetMaintenanceApiController::class, 'show']);
            });

            Route::prefix('service-softwares')->group(function () {
                Route::get('index', [ApplicationAssetApiController::class, 'index']);
                Route::post('store', [ApplicationAssetApiController::class, 'store']);
                Route::get('details', [ApplicationAssetApiController::class, 'details']);

                Route::prefix('vendors')->group(function () {
                    Route::post('store', [ApplicationAssetVendorApiController::class, 'store']);

                    Route::prefix('contracts')->group(function () {
                        Route::get('index', [ApplicationAssetVendorContractApiController::class, 'index']);
                        Route::post('store', [ApplicationAssetVendorContractApiController::class, 'store']);
                        Route::get('show', [ApplicationAssetVendorContractApiController::class, 'show']);
                    });
                });
            });
        });

        Route::prefix('users')->group(function () {
            Route::get('index', [AuthController::class, 'index']);
            Route::get('show', [AuthController::class, 'show']);
            Route::post('store', [AuthController::class, 'register']);
            Route::post('update', [AuthController::class, 'update']);
            Route::post('logout', [AuthController::class, 'logout']);
            Route::post('update-user-status', [AuthController::class, 'user_status']);
            Route::get('sync-authorization', [AuthController::class, 'sync_authorization']);

            Route::get('roles', [AuthController::class, 'roles']);
            Route::post('role/store', [AuthController::class, 'createRole']);
            Route::post('role/update', [AuthController::class, 'updateRole']);

            Route::get('permissions', [AuthController::class, 'permissions']);
        });

        Route::prefix('administrations')->group(function () {
            Route::prefix('employees')->group(function () {
                Route::get('index', [EmployeeApiController::class, 'index']);
                Route::get('show', [EmployeeApiController::class, 'show']);
                Route::get('select', [EmployeeApiController::class, 'employeeForSelect']);
                Route::post('synchronize', [AssetAllocationApiController::class, 'hr']);
                Route::get('all', [EmployeeApiController::class, 'employees']);
            });

            Route::prefix('branches')->group(function () {
                Route::get('index', [BranchApiController::class, 'index']);
                Route::get('select', [BranchApiController::class, 'branchForSelect']);
            });

            Route::prefix('branch-points')->group(function () {
                Route::get('index', [BranchPointApiController::class, 'index']);
                Route::get('show', [BranchPointApiController::class, 'show']);
                Route::post('store', [BranchPointApiController::class, 'store']);
                Route::post('update', [BranchPointApiController::class, 'update']);
                Route::get('select', [BranchPointApiController::class, 'branchPointForSelect']);
                Route::get('check', [BranchPointApiController::class, 'checkBranchPoint']);
            });
        });

        Route::prefix('operations')->group(function () {
            Route::get('dashboard/index', [DashboardApiController::class, 'index']);
            Route::get('reports/hardware/excel', [ReportController::class, 'hardware_assets_excel']);
            Route::get('reports/hardware/pdf', [ReportController::class, 'hardware_assets_pdf']);
        });
        
    });
});
