<!DOCTYPE html>
<html>
<head>
    <style>
        .container {/* overflow: hidden; Clear floats */}
        .left { float: left; line-height: 20px; }
        .right {float: right;  padding: 10px; line-height: 1 }
        .border{ border-top: 5px solid #641a07}

        .table_content{margin-top: 15px; width: 100%; border-collapse: collapse;}
        .table_content th{ background-color: #273488; color: white; border: 1px solid #273488;}
        .table_content td{border: 1px solid #273488;}
        td,th{ padding-left: 3px; font-size:10pt}

        thead {
            display: table-header-group;  /* 👈 ensures header repeats */
        }

        tfoot {
            display: table-footer-group;  /* optional: repeat footer */
        }

        tbody {
            display: table-row-group;
        }

    </style>
</head>
    <body>

        <div class="container">
            <div class="left">
                <img src="<?php echo e(public_path('images/zic_black.png')); ?>" style="width: 210px; margin-bottom: 5px"></img>
            </div>
            <div class="right">
                <table class="zic_table">
                    <tr><td>Bima House No. 1. Mpirani Street</td></tr>
                    <tr><td>Mlandege Road P.O.Box 432</td></tr>
                    <tr><td>71102 Urban West, Zanzibar</td></tr>
                </table>
            </div>
            <div style="clear: both"></div>
            <div class="border"></div>
            <div><h4 style="text-align: center">INVENTORY REPORT UP TO - <?php echo e($date); ?></h4></div>

            <table class="table_content">
                <thead>
                    <tr>
                        <th style="text-align: left; min-width:20px">#</th>
                        <th style="text-align: left">ITEM NAME</th>
                        <th style="text-align: left">BIN LOCATION</th>
                        <th style="text-align: left">ITEM TYPE</th>
                        <th style="text-align: left">UOM</th>
                        <th style="text-align: right">RECEIVED/O.BALANCE</th>
                        <th style="text-align: right">REQUESTED</th>
                        <th style="text-align: right">AVAILABLE</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($loop->iteration); ?></td>
                            <td><?php echo e($item['name']); ?></td>
                            <td><?php echo e($item['bin']); ?></td>
                            <td><?php echo e($item['type']); ?></td>
                            <td><?php echo e($item['uom']); ?></td>
                            <td style="text-align: right; padding-right: 5px"><?php echo e($item['received']); ?></td>
                            <td style="text-align: right; padding-right: 5px"><?php echo e($item['requested']); ?></td>
                            <td style="text-align: right; padding-right: 5px"><?php echo e($item['balance']); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </body>
</html>
<?php /**PATH /home/muhamadi/Developments/store/laravel/resources/views/reports/inventory-by-date.blade.php ENDPATH**/ ?>