<!DOCTYPE html>
<html>
<head>
    <style>
        .container {/* overflow: hidden; Clear floats */}
        .left { float: left; line-height: 20px; }
        .right {float: right;  padding: 10px; line-height: 26px }
        .supplier{background-color: #273488; color: white; padding: 5px; font-weight: bold; margin-top: 10px}
        .supplier_table td{padding-bottom: 3px}
        .zic_table td{padding-bottom: 3px}
        .table_content{margin-top: 15px; width: 100%; border-collapse: collapse;}
        .table_content th{ background-color: #273488; color: white; border: 1px solid #273488;}
        .table_content td{border: 1px solid #273488;}
        .summary{width: 100%; border-collapse: collapse;}
        .summary th{ text-align: left;padding-right: 15px}
        .summary td{ border-bottom: 1px solid #273488; padding-right: 10px; padding-left: 10px; text-align: right }
        .order{width: 100%; border-collapse: collapse;}
        .order th{ text-align: left;padding-right: 25px}

    </style>
</head>
<body>

    <div class="container">
        <div class="left">
            <img src="<?php echo e(public_path('images/zic_black.png')); ?>" style="width: 210px; margin-bottom: 5px"></img>
            <table class="zic_table">
                <tr><td>Bima House No. 1. Mpirani Street</td></tr>
                <tr><td>Mlandege Road P.O.Box 432</td></tr>
                <tr><td>71102 Urban West, Zanzibar</td></tr>
                <tr><td>+255 659 072 500</td></tr>
                <tr><td>email: zichq@zic.co.tz | website: <a href="www.zic.co.tz" target="_blank" style="color:#273488; text-decoration: none;">www.zic.co.tz</a></td></tr>
            </table>
        </div>
        <div class="right">
            <h1 style="padding: 15px 0 5px 0; margin: 0;color: #273488">PURCHASE ORDER</h1>

            <div class="right">
        <table class="order">
            <tr><th>Date</th><td><?php echo e($data['date']); ?></td></tr>
            <tr><th>Order #</th><td><?php echo e($data['purchase_order']['purchase_order_number']); ?></td></tr>
        </table>
    </div>
        </div>
    </div>
    <div style="clear: both"></div>
    <div class="supplier">ISSUED TO</div>
    <table class="supplier_table">
        <tr><td><?php echo e($data['purchase_order']['supplier']['name']); ?></td></tr>
        <tr><td>P.O.Box</td></tr>
        <tr><td><?php echo e($data['purchase_order']['supplier']['phone']); ?></td></tr>
    </table>

    <table class="table_content">
        <tr>
            <th style="text-align: left">PRODUCT</th>
            <th style="text-align: left">DESCRIPTION</th>
            <th style="text-align: right">QUANTITY</th>
            <th style="text-align: right">UNIT PRICE</th>
            <th style="text-align: right">TOTAL (<?php echo e($data['purchase_order']['currency']['name']); ?>)</th>
        </tr>
        <?php $__currentLoopData = $data['items']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr>
            <td><?php echo e($item['item_name']); ?></td>
            <td style="max-width: 250px"><p><?php echo e($item['detail']); ?></p></td>
            <td style="text-align: right; padding-right: 5px"><?php echo e($item['quantity'].' '.$item['measure']); ?></td>
            <td style="text-align: right; padding-right: 5px"><?php echo e($item['unit_price']); ?></td>
            <td style="text-align: right; padding-right: 5px"><?php echo e($item['total_amount']); ?></td>
        </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </table>
    <?php if($data['purchase_order']['notes'] != 'N/A'): ?>
        <div style="margin-top: 10px">
            <strong>Notes</strong>
            <table style="width: 100%;">
                <tr><td><?php echo e($data['purchase_order']['notes']); ?></td></tr>
            </table>
        </div>
    <?php endif; ?>
   
    <div class="right" style="margin-top: 20px">
        <table class="summary">
            <tr><th>SUB TOTAL</th><td><?php echo e($data['amount']); ?></td></tr>
            <?php if($data['taxation'] != '0.00'): ?>
            <tr><th>TAX</th><td><?php echo e($data['taxation']); ?></td></tr> 
            <?php endif; ?>
            <?php if($data['with_holding_tax'] != '0.00'): ?>
            <tr><th>WHD TAX</th><td><?php echo e($data['with_holding_tax']); ?></td></tr> 
            <?php endif; ?>
            <tr><th>TOTAL</th><td><strong><?php echo e($data['total_amount']); ?></strong></td></tr>
        </table>
    </div>
    <div style="clear: both"></div>
    <div>
        <span>_____________________________</span>
        <table>
            <tr><td><?php echo e($data['purchase_order']['createdBy']['name']); ?></td></tr>
            <tr><td>For, Zanzibar Insurance Corporation</td></tr>
        </table>
    </div>
    
</body>
</html>
<?php /**PATH /home/muhamadi/Developments/fixedAsset/resources/views/lpo/create_lpo.blade.php ENDPATH**/ ?>